/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;

final class FlowableElementAtSingle$ElementAtSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    final SingleObserver<? super T> actual;
    final long index;
    final T defaultValue;
    Yy s;
    long count;
    boolean done;

    FlowableElementAtSingle$ElementAtSubscriber(SingleObserver<? super T> actual, long index, T defaultValue) {
        this.actual = actual;
        this.index = index;
        this.defaultValue = defaultValue;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        long c2 = this.count;
        if (c2 == this.index) {
            this.done = true;
            this.s.cancel();
            this.s = SubscriptionHelper.CANCELLED;
            this.actual.onSuccess(t2);
            return;
        }
        this.count = c2 + 1L;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.s = SubscriptionHelper.CANCELLED;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        this.s = SubscriptionHelper.CANCELLED;
        if (!this.done) {
            this.done = true;
            T v2 = this.defaultValue;
            if (v2 != null) {
                this.actual.onSuccess(v2);
            } else {
                this.actual.onError(new NoSuchElementException());
            }
        }
    }

    @Override
    public void dispose() {
        this.s.cancel();
        this.s = SubscriptionHelper.CANCELLED;
    }

    @Override
    public boolean isDisposed() {
        return this.s == SubscriptionHelper.CANCELLED;
    }
}

