/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableFlatMap$MergeSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableFlatMap$InnerSubscriber<T, U>
extends AtomicReference<Yy>
implements FlowableSubscriber<U>,
Disposable {
    private static final long serialVersionUID = -4606175640614850599L;
    final long id;
    final FlowableFlatMap$MergeSubscriber<T, U> parent;
    final int limit;
    final int bufferSize;
    volatile boolean done;
    volatile SimpleQueue<U> queue;
    long produced;
    int fusionMode;

    FlowableFlatMap$InnerSubscriber(FlowableFlatMap$MergeSubscriber<T, U> parent, long id2) {
        this.id = id2;
        this.parent = parent;
        this.bufferSize = parent.bufferSize;
        this.limit = this.bufferSize >> 2;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(7);
                if (m2 == 1) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m2 == 2) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                }
            }
            s2.request(this.bufferSize);
        }
    }

    @Override
    public void onNext(U t2) {
        if (this.fusionMode != 2) {
            this.parent.tryEmit(t2, this);
        } else {
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.lazySet(SubscriptionHelper.CANCELLED);
        this.parent.innerError(this, t2);
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.parent.drain();
    }

    void requestMore(long n2) {
        if (this.fusionMode != 1) {
            long p2 = this.produced + n2;
            if (p2 >= (long)this.limit) {
                this.produced = 0L;
                ((Yy)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }
}

