/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableFlattenIterable$FlattenIterableSubscriber;
import io.reactivex.internal.operators.flowable.FlowableFromIterable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Iterator;
import java.util.concurrent.Callable;

public final class FlowableFlattenIterable<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;

    public FlowableFlattenIterable(Flowable<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        super(source);
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Yx<? super R> s2) {
        if (this.source instanceof Callable) {
            Iterator<? extends R> it2;
            Object v2;
            try {
                v2 = ((Callable)((Object)this.source)).call();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptySubscription.error(ex2, s2);
                return;
            }
            if (v2 == null) {
                EmptySubscription.complete(s2);
                return;
            }
            try {
                Iterable<R> iterable = this.mapper.apply(v2);
                it2 = iterable.iterator();
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                EmptySubscription.error(ex3, s2);
                return;
            }
            FlowableFromIterable.subscribe(s2, it2);
            return;
        }
        this.source.subscribe(new FlowableFlattenIterable$FlattenIterableSubscriber<T, R>(s2, this.mapper, this.prefetch));
    }
}

