/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;

abstract class FlowableFromArray$BaseArraySubscription<T>
extends BasicQueueSubscription<T> {
    private static final long serialVersionUID = -2252972430506210021L;
    final T[] array;
    int index;
    volatile boolean cancelled;

    FlowableFromArray$BaseArraySubscription(T[] array) {
        this.array = array;
    }

    @Override
    public final int requestFusion(int mode) {
        return mode & 1;
    }

    @Override
    @Nullable
    public final T poll() {
        int i2 = this.index;
        T[] arr = this.array;
        if (i2 == arr.length) {
            return null;
        }
        this.index = i2 + 1;
        return ObjectHelper.requireNonNull(arr[i2], "array element is null");
    }

    @Override
    public final boolean isEmpty() {
        return this.index == this.array.length;
    }

    @Override
    public final void clear() {
        this.index = this.array.length;
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2) && BackpressureHelper.add(this, n2) == 0L) {
            if (n2 == Long.MAX_VALUE) {
                this.fastPath();
            } else {
                this.slowPath(n2);
            }
        }
    }

    @Override
    public final void cancel() {
        this.cancelled = true;
    }

    abstract void fastPath();

    abstract void slowPath(long var1);
}

