/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class FlowableFromFuture<T>
extends Flowable<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public FlowableFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        T v2;
        DeferredScalarSubscription<T> deferred = new DeferredScalarSubscription<T>(s2);
        s2.onSubscribe(deferred);
        try {
            v2 = this.unit != null ? this.future.get(this.timeout, this.unit) : this.future.get();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            if (!deferred.isCancelled()) {
                s2.onError(ex2);
            }
            return;
        }
        if (v2 == null) {
            s2.onError(new NullPointerException("The future returned null"));
        } else {
            deferred.complete(v2);
        }
    }
}

