/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.Iterator;

abstract class FlowableFromIterable$BaseRangeSubscription<T>
extends BasicQueueSubscription<T> {
    private static final long serialVersionUID = -2252972430506210021L;
    Iterator<? extends T> it;
    volatile boolean cancelled;
    boolean once;

    FlowableFromIterable$BaseRangeSubscription(Iterator<? extends T> it2) {
        this.it = it2;
    }

    @Override
    public final int requestFusion(int mode) {
        return mode & 1;
    }

    @Override
    @Nullable
    public final T poll() {
        if (this.it == null) {
            return null;
        }
        if (!this.once) {
            this.once = true;
        } else if (!this.it.hasNext()) {
            return null;
        }
        return ObjectHelper.requireNonNull(this.it.next(), "Iterator.next() returned a null value");
    }

    @Override
    public final boolean isEmpty() {
        return this.it == null || !this.it.hasNext();
    }

    @Override
    public final void clear() {
        this.it = null;
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2) && BackpressureHelper.add(this, n2) == 0L) {
            if (n2 == Long.MAX_VALUE) {
                this.fastPath();
            } else {
                this.slowPath(n2);
            }
        }
    }

    @Override
    public final void cancel() {
        this.cancelled = true;
    }

    abstract void fastPath();

    abstract void slowPath(long var1);
}

