/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.flowables.GroupedFlowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableGroupBy$GroupedUnicast;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class FlowableGroupBy$GroupBySubscriber<T, K, V>
extends BasicIntQueueSubscription<GroupedFlowable<K, V>>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -3688291656102519502L;
    final Yx<? super GroupedFlowable<K, V>> actual;
    final Function<? super T, ? extends K> keySelector;
    final Function<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;
    final Map<Object, FlowableGroupBy$GroupedUnicast<K, V>> groups;
    final SpscLinkedArrayQueue<GroupedFlowable<K, V>> queue;
    static final Object NULL_KEY = new Object();
    Yy s;
    final AtomicBoolean cancelled = new AtomicBoolean();
    final AtomicLong requested = new AtomicLong();
    final AtomicInteger groupCount = new AtomicInteger(1);
    Throwable error;
    volatile boolean done;
    boolean outputFused;

    public FlowableGroupBy$GroupBySubscriber(Yx<? super GroupedFlowable<K, V>> actual, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
        this.actual = actual;
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
        this.groups = new ConcurrentHashMap<Object, FlowableGroupBy$GroupedUnicast<K, V>>();
        this.queue = new SpscLinkedArrayQueue(bufferSize);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(this.bufferSize);
        }
    }

    @Override
    public void onNext(T t2) {
        V v2;
        K key;
        if (this.done) {
            return;
        }
        SpscLinkedArrayQueue<GroupedFlowable<K, V>> q2 = this.queue;
        try {
            key = this.keySelector.apply(t2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.s.cancel();
            this.onError(ex2);
            return;
        }
        boolean newGroup = false;
        Object mapKey = key != null ? key : NULL_KEY;
        FlowableGroupBy$GroupedUnicast<K, Object> group = this.groups.get(mapKey);
        if (group == null) {
            if (this.cancelled.get()) {
                return;
            }
            group = FlowableGroupBy$GroupedUnicast.createWith(key, this.bufferSize, this, this.delayError);
            this.groups.put(mapKey, group);
            this.groupCount.getAndIncrement();
            newGroup = true;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.valueSelector.apply(t2), "The valueSelector returned null");
        }
        catch (Throwable ex3) {
            Exceptions.throwIfFatal(ex3);
            this.s.cancel();
            this.onError(ex3);
            return;
        }
        group.onNext(v2);
        if (newGroup) {
            q2.offer(group);
            this.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        for (FlowableGroupBy$GroupedUnicast<K, V> g2 : this.groups.values()) {
            g2.onError(t2);
        }
        this.groups.clear();
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            for (FlowableGroupBy$GroupedUnicast<K, V> g2 : this.groups.values()) {
                g2.onComplete();
            }
            this.groups.clear();
            this.done = true;
            this.drain();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (this.cancelled.compareAndSet(false, true) && this.groupCount.decrementAndGet() == 0) {
            this.s.cancel();
        }
    }

    public void cancel(K key) {
        Object mapKey = key != null ? key : NULL_KEY;
        this.groups.remove(mapKey);
        if (this.groupCount.decrementAndGet() == 0) {
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        if (this.outputFused) {
            this.drainFused();
        } else {
            this.drainNormal();
        }
    }

    void drainFused() {
        int missed = 1;
        SpscLinkedArrayQueue<GroupedFlowable<K, V>> q2 = this.queue;
        Yx<GroupedFlowable<K, V>> a2 = this.actual;
        do {
            Throwable ex2;
            if (this.cancelled.get()) {
                q2.clear();
                return;
            }
            boolean d2 = this.done;
            if (d2 && !this.delayError && (ex2 = this.error) != null) {
                q2.clear();
                a2.onError(ex2);
                return;
            }
            a2.onNext(null);
            if (!d2) continue;
            ex2 = this.error;
            if (ex2 != null) {
                a2.onError(ex2);
            } else {
                a2.onComplete();
            }
            return;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    void drainNormal() {
        int missed = 1;
        SpscLinkedArrayQueue<GroupedFlowable<K, V>> q2 = this.queue;
        Yx<GroupedFlowable<K, V>> a2 = this.actual;
        do {
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                boolean empty;
                boolean d2 = this.done;
                GroupedFlowable<K, V> t2 = q2.poll();
                boolean bl2 = empty = t2 == null;
                if (this.checkTerminated(d2, empty, a2, q2)) {
                    return;
                }
                if (empty) break;
                a2.onNext(t2);
            }
            if (e2 == r2 && this.checkTerminated(this.done, q2.isEmpty(), a2, q2)) {
                return;
            }
            if (e2 == 0L) continue;
            if (r2 != Long.MAX_VALUE) {
                this.requested.addAndGet(-e2);
            }
            this.s.request(e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean d2, boolean empty, Yx<?> a2, SpscLinkedArrayQueue<?> q2) {
        if (this.cancelled.get()) {
            q2.clear();
            return true;
        }
        if (this.delayError) {
            if (d2 && empty) {
                Throwable ex2 = this.error;
                if (ex2 != null) {
                    a2.onError(ex2);
                } else {
                    a2.onComplete();
                }
                return true;
            }
        } else if (d2) {
            Throwable ex3 = this.error;
            if (ex3 != null) {
                q2.clear();
                a2.onError(ex3);
                return true;
            }
            if (empty) {
                a2.onComplete();
                return true;
            }
        }
        return false;
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    @Nullable
    public GroupedFlowable<K, V> poll() {
        return this.queue.poll();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

