/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableInterval$IntervalSubscriber
extends AtomicLong
implements Yy,
Runnable {
    private static final long serialVersionUID = -2809475196591179431L;
    final Yx<? super Long> actual;
    long count;
    final AtomicReference<Disposable> resource = new AtomicReference();

    FlowableInterval$IntervalSubscriber(Yx<? super Long> actual) {
        this.actual = actual;
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this, n2);
        }
    }

    @Override
    public void cancel() {
        DisposableHelper.dispose(this.resource);
    }

    @Override
    public void run() {
        if (this.resource.get() != DisposableHelper.DISPOSED) {
            long r2 = this.get();
            if (r2 != 0L) {
                this.actual.onNext((Long)this.count++);
                BackpressureHelper.produced(this, 1L);
            } else {
                this.actual.onError(new MissingBackpressureException("Can't deliver value " + this.count + " due to lack of requests"));
                DisposableHelper.dispose(this.resource);
            }
        }
    }

    public void setResource(Disposable d2) {
        DisposableHelper.setOnce(this.resource, d2);
    }
}

