/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableOperator;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class FlowableLift<R, T>
extends AbstractFlowableWithUpstream<T, R> {
    final FlowableOperator<? extends R, ? super T> operator;

    public FlowableLift(Flowable<T> source, FlowableOperator<? extends R, ? super T> operator) {
        super(source);
        this.operator = operator;
    }

    @Override
    public void subscribeActual(Yx<? super R> s2) {
        try {
            Yx<? super T> st2 = this.operator.apply(s2);
            if (st2 == null) {
                throw new NullPointerException("Operator " + this.operator + " returned a null Subscriber");
            }
            this.source.subscribe(st2);
        }
        catch (NullPointerException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(e3);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e3);
            throw npe;
        }
    }
}

