/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

abstract class FlowableObserveOn$BaseObserveOnSubscriber<T>
extends BasicIntQueueSubscription<T>
implements FlowableSubscriber<T>,
Runnable {
    private static final long serialVersionUID = -8241002408341274697L;
    final Scheduler$Worker worker;
    final boolean delayError;
    final int prefetch;
    final int limit;
    final AtomicLong requested;
    Yy s;
    SimpleQueue<T> queue;
    volatile boolean cancelled;
    volatile boolean done;
    Throwable error;
    int sourceMode;
    long produced;
    boolean outputFused;

    FlowableObserveOn$BaseObserveOnSubscriber(Scheduler$Worker worker, boolean delayError, int prefetch) {
        this.worker = worker;
        this.delayError = delayError;
        this.prefetch = prefetch;
        this.requested = new AtomicLong();
        this.limit = prefetch - (prefetch >> 2);
    }

    @Override
    public final void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.sourceMode == 2) {
            this.trySchedule();
            return;
        }
        if (!this.queue.offer(t2)) {
            this.s.cancel();
            this.error = new MissingBackpressureException("Queue is full?!");
            this.done = true;
        }
        this.trySchedule();
    }

    @Override
    public final void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.trySchedule();
    }

    @Override
    public final void onComplete() {
        if (!this.done) {
            this.done = true;
            this.trySchedule();
        }
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.trySchedule();
        }
    }

    @Override
    public final void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.s.cancel();
        this.worker.dispose();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
        }
    }

    final void trySchedule() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        this.worker.schedule(this);
    }

    @Override
    public final void run() {
        if (this.outputFused) {
            this.runBackfused();
        } else if (this.sourceMode == 1) {
            this.runSync();
        } else {
            this.runAsync();
        }
    }

    abstract void runBackfused();

    abstract void runSync();

    abstract void runAsync();

    final boolean checkTerminated(boolean d2, boolean empty, Yx<?> a2) {
        if (this.cancelled) {
            this.clear();
            return true;
        }
        if (d2) {
            if (this.delayError) {
                if (empty) {
                    Throwable e2 = this.error;
                    if (e2 != null) {
                        a2.onError(e2);
                    } else {
                        a2.onComplete();
                    }
                    this.worker.dispose();
                    return true;
                }
            } else {
                Throwable e3 = this.error;
                if (e3 != null) {
                    this.clear();
                    a2.onError(e3);
                    this.worker.dispose();
                    return true;
                }
                if (empty) {
                    a2.onComplete();
                    this.worker.dispose();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public final int requestFusion(int requestedMode) {
        if ((requestedMode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    public final void clear() {
        this.queue.clear();
    }

    @Override
    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

