/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableOnBackpressureLatest$BackpressureLatestSubscriber<T>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 163080509307634843L;
    final Yx<? super T> actual;
    Yy s;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;
    final AtomicLong requested = new AtomicLong();
    final AtomicReference<T> current = new AtomicReference();

    FlowableOnBackpressureLatest$BackpressureLatestSubscriber(Yx<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        this.current.lazySet(t2);
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.current.lazySet(null);
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Yx<Object> a2 = this.actual;
        int missed = 1;
        AtomicLong r2 = this.requested;
        AtomicReference<T> q2 = this.current;
        do {
            long e2;
            for (e2 = 0L; e2 != r2.get(); ++e2) {
                boolean empty;
                boolean d2 = this.done;
                Object v2 = q2.getAndSet(null);
                boolean bl2 = empty = v2 == null;
                if (this.checkTerminated(d2, empty, a2, q2)) {
                    return;
                }
                if (empty) break;
                a2.onNext(v2);
            }
            if (e2 == r2.get() && this.checkTerminated(this.done, q2.get() == null, a2, q2)) {
                return;
            }
            if (e2 == 0L) continue;
            BackpressureHelper.produced(r2, e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean d2, boolean empty, Yx<?> a2, AtomicReference<T> q2) {
        if (this.cancelled) {
            q2.lazySet(null);
            return true;
        }
        if (d2) {
            Throwable e2 = this.error;
            if (e2 != null) {
                q2.lazySet(null);
                a2.onError(e2);
                return true;
            }
            if (empty) {
                a2.onComplete();
                return true;
            }
        }
        return false;
    }
}

