/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.plugins.RxJavaPlugins;

final class FlowableOnErrorNext$OnErrorNextSubscriber<T>
implements FlowableSubscriber<T> {
    final Yx<? super T> actual;
    final Function<? super Throwable, ? extends Yw<? extends T>> nextSupplier;
    final boolean allowFatal;
    final SubscriptionArbiter arbiter;
    boolean once;
    boolean done;

    FlowableOnErrorNext$OnErrorNextSubscriber(Yx<? super T> actual, Function<? super Throwable, ? extends Yw<? extends T>> nextSupplier, boolean allowFatal) {
        this.actual = actual;
        this.nextSupplier = nextSupplier;
        this.allowFatal = allowFatal;
        this.arbiter = new SubscriptionArbiter();
    }

    @Override
    public void onSubscribe(Yy s2) {
        this.arbiter.setSubscription(s2);
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        this.actual.onNext(t2);
        if (!this.once) {
            this.arbiter.produced(1L);
        }
    }

    @Override
    public void onError(Throwable t2) {
        Yw<T> p2;
        if (this.once) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.actual.onError(t2);
            return;
        }
        this.once = true;
        if (this.allowFatal && !(t2 instanceof Exception)) {
            this.actual.onError(t2);
            return;
        }
        try {
            p2 = this.nextSupplier.apply(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(new CompositeException(t2, e2));
            return;
        }
        if (p2 == null) {
            NullPointerException npe = new NullPointerException("Publisher is null");
            npe.initCause(t2);
            this.actual.onError(npe);
            return;
        }
        p2.subscribe(this);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.once = true;
        this.actual.onComplete();
    }
}

