/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowablePublish$InnerSubscriber;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class FlowablePublish$PublishSubscriber<T>
extends AtomicInteger
implements FlowableSubscriber<T>,
Disposable {
    private static final long serialVersionUID = -202316842419149694L;
    static final FlowablePublish$InnerSubscriber[] EMPTY = new FlowablePublish$InnerSubscriber[0];
    static final FlowablePublish$InnerSubscriber[] TERMINATED = new FlowablePublish$InnerSubscriber[0];
    final AtomicReference<FlowablePublish$PublishSubscriber<T>> current;
    final int bufferSize;
    final AtomicReference<FlowablePublish$InnerSubscriber[]> subscribers;
    final AtomicBoolean shouldConnect;
    final AtomicReference<Yy> s = new AtomicReference();
    volatile Object terminalEvent;
    int sourceMode;
    volatile SimpleQueue<T> queue;

    FlowablePublish$PublishSubscriber(AtomicReference<FlowablePublish$PublishSubscriber<T>> current, int bufferSize) {
        this.subscribers = new AtomicReference<FlowablePublish$InnerSubscriber[]>(EMPTY);
        this.current = current;
        this.shouldConnect = new AtomicBoolean();
        this.bufferSize = bufferSize;
    }

    @Override
    public void dispose() {
        FlowablePublish$InnerSubscriber[] ps2;
        if (this.subscribers.get() != TERMINATED && (ps2 = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
            this.current.compareAndSet(this, null);
            SubscriptionHelper.cancel(this.s);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.subscribers.get() == TERMINATED;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.s, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(3);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    this.terminalEvent = NotificationLite.complete();
                    this.dispatch();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    s2.request(this.bufferSize);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.bufferSize);
            s2.request(this.bufferSize);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.sourceMode == 0 && !this.queue.offer(t2)) {
            this.onError(new MissingBackpressureException("Prefetch queue is full?!"));
            return;
        }
        this.dispatch();
    }

    @Override
    public void onError(Throwable e2) {
        if (this.terminalEvent == null) {
            this.terminalEvent = NotificationLite.error(e2);
            this.dispatch();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (this.terminalEvent == null) {
            this.terminalEvent = NotificationLite.complete();
            this.dispatch();
        }
    }

    boolean add(FlowablePublish$InnerSubscriber<T> producer) {
        FlowablePublish$InnerSubscriber[] u2;
        FlowablePublish$InnerSubscriber[] c2;
        do {
            if ((c2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = c2.length;
            u2 = new FlowablePublish$InnerSubscriber[len + 1];
            System.arraycopy(c2, 0, u2, 0, len);
            u2[len] = producer;
        } while (!this.subscribers.compareAndSet(c2, u2));
        return true;
    }

    void remove(FlowablePublish$InnerSubscriber<T> producer) {
        FlowablePublish$InnerSubscriber[] c2;
        int len;
        while ((len = (c2 = this.subscribers.get()).length) != 0) {
            FlowablePublish$InnerSubscriber[] u2;
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (!c2[i2].equals(producer)) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                u2 = EMPTY;
            } else {
                u2 = new FlowablePublish$InnerSubscriber[len - 1];
                System.arraycopy(c2, 0, u2, 0, j2);
                System.arraycopy(c2, j2 + 1, u2, j2, len - j2 - 1);
            }
            if (!this.subscribers.compareAndSet(c2, u2)) continue;
            break;
        }
    }

    boolean checkTerminated(Object term, boolean empty) {
        if (term != null) {
            if (NotificationLite.isComplete(term)) {
                if (empty) {
                    this.current.compareAndSet(this, null);
                    for (FlowablePublish$InnerSubscriber ip2 : this.subscribers.getAndSet(TERMINATED)) {
                        ip2.child.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable t2 = NotificationLite.getError(term);
                this.current.compareAndSet(this, null);
                FlowablePublish$InnerSubscriber[] a2 = this.subscribers.getAndSet(TERMINATED);
                if (a2.length != 0) {
                    for (FlowablePublish$InnerSubscriber ip3 : a2) {
                        ip3.child.onError(t2);
                    }
                } else {
                    RxJavaPlugins.onError(t2);
                }
                return true;
            }
        }
        return false;
    }

    void dispatch() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        while (true) {
            boolean empty;
            Object term = this.terminalEvent;
            SimpleQueue<T> q2 = this.queue;
            boolean bl2 = empty = q2 == null || q2.isEmpty();
            if (this.checkTerminated(term, empty)) {
                return;
            }
            if (!empty) {
                FlowablePublish$InnerSubscriber[] ps2 = this.subscribers.get();
                int len = ps2.length;
                long maxRequested = Long.MAX_VALUE;
                int cancelled = 0;
                for (FlowablePublish$InnerSubscriber ip2 : ps2) {
                    long r2 = ip2.get();
                    if (r2 >= 0L) {
                        maxRequested = Math.min(maxRequested, r2);
                        continue;
                    }
                    if (r2 != Long.MIN_VALUE) continue;
                    ++cancelled;
                }
                if (len == cancelled) {
                    T v2;
                    term = this.terminalEvent;
                    try {
                        v2 = q2.poll();
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal(ex2);
                        this.s.get().cancel();
                        this.terminalEvent = term = NotificationLite.error(ex2);
                        v2 = null;
                    }
                    if (this.checkTerminated(term, v2 == null)) {
                        return;
                    }
                    if (this.sourceMode == 1) continue;
                    this.s.get().request(1L);
                    continue;
                }
                int d2 = 0;
                while ((long)d2 < maxRequested) {
                    T v3;
                    term = this.terminalEvent;
                    try {
                        v3 = q2.poll();
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        this.s.get().cancel();
                        this.terminalEvent = term = NotificationLite.error(ex3);
                        v3 = null;
                    }
                    boolean bl3 = empty = v3 == null;
                    if (this.checkTerminated(term, empty)) {
                        return;
                    }
                    if (empty) break;
                    Object value = NotificationLite.getValue(v3);
                    for (FlowablePublish$InnerSubscriber ip3 : ps2) {
                        if (ip3.get() <= 0L) continue;
                        ip3.child.onNext(value);
                        ip3.produced(1L);
                    }
                    ++d2;
                }
                if (d2 > 0 && this.sourceMode != 1) {
                    this.s.get().request(d2);
                }
                if (maxRequested != 0L && !empty) continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }
}

