/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;

abstract class FlowableRangeLong$BaseRangeSubscription
extends BasicQueueSubscription<Long> {
    private static final long serialVersionUID = -2252972430506210021L;
    final long end;
    long index;
    volatile boolean cancelled;

    FlowableRangeLong$BaseRangeSubscription(long index, long end) {
        this.index = index;
        this.end = end;
    }

    @Override
    public final int requestFusion(int mode) {
        return mode & 1;
    }

    @Override
    @Nullable
    public final Long poll() {
        long i2 = this.index;
        if (i2 == this.end) {
            return null;
        }
        this.index = i2 + 1L;
        return i2;
    }

    @Override
    public final boolean isEmpty() {
        return this.index == this.end;
    }

    @Override
    public final void clear() {
        this.index = this.end;
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2) && BackpressureHelper.add(this, n2) == 0L) {
            if (n2 == Long.MAX_VALUE) {
                this.fastPath();
            } else {
                this.slowPath(n2);
            }
        }
    }

    @Override
    public final void cancel() {
        this.cancelled = true;
    }

    abstract void fastPath();

    abstract void slowPath(long var1);
}

