/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class FlowableReduce$ReduceSubscriber<T>
extends DeferredScalarSubscription<T>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -4663883003264602070L;
    final BiFunction<T, T, T> reducer;
    Yy s;

    FlowableReduce$ReduceSubscriber(Yx<? super T> actual, BiFunction<T, T, T> reducer) {
        super(actual);
        this.reducer = reducer;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.s == SubscriptionHelper.CANCELLED) {
            return;
        }
        Object v2 = this.value;
        if (v2 == null) {
            this.value = t2;
        } else {
            try {
                this.value = ObjectHelper.requireNonNull(this.reducer.apply(v2, t2), "The reducer returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.s.cancel();
                this.onError(ex2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.s == SubscriptionHelper.CANCELLED) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.s = SubscriptionHelper.CANCELLED;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.s == SubscriptionHelper.CANCELLED) {
            return;
        }
        this.s = SubscriptionHelper.CANCELLED;
        Object v2 = this.value;
        if (v2 != null) {
            this.complete(v2);
        } else {
            this.actual.onComplete();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.s.cancel();
        this.s = SubscriptionHelper.CANCELLED;
    }
}

