/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;

final class FlowableReduceSeedSingle$ReduceSeedObserver<T, R>
implements FlowableSubscriber<T>,
Disposable {
    final SingleObserver<? super R> actual;
    final BiFunction<R, ? super T, R> reducer;
    R value;
    Yy s;

    FlowableReduceSeedSingle$ReduceSeedObserver(SingleObserver<? super R> actual, BiFunction<R, ? super T, R> reducer, R value) {
        this.actual = actual;
        this.value = value;
        this.reducer = reducer;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T value) {
        R v2 = this.value;
        try {
            this.value = ObjectHelper.requireNonNull(this.reducer.apply(v2, value), "The reducer returned a null value");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.s.cancel();
            this.onError(ex2);
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.value = null;
        this.s = SubscriptionHelper.CANCELLED;
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        R v2 = this.value;
        this.value = null;
        this.s = SubscriptionHelper.CANCELLED;
        this.actual.onSuccess(v2);
    }

    @Override
    public void dispose() {
        this.s.cancel();
        this.s = SubscriptionHelper.CANCELLED;
    }

    @Override
    public boolean isDisposed() {
        return this.s == SubscriptionHelper.CANCELLED;
    }
}

