/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableReduceSeedSingle$ReduceSeedObserver;
import java.util.concurrent.Callable;

public final class FlowableReduceWithSingle<T, R>
extends Single<R> {
    final Yw<T> source;
    final Callable<R> seedSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public FlowableReduceWithSingle(Yw<T> source, Callable<R> seedSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.seedSupplier = seedSupplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribeActual(SingleObserver<? super R> observer) {
        R seed;
        try {
            seed = ObjectHelper.requireNonNull(this.seedSupplier.call(), "The seedSupplier returned a null value");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptyDisposable.error(ex2, observer);
            return;
        }
        this.source.subscribe(new FlowableReduceSeedSingle$ReduceSeedObserver<T, R>(observer, this.reducer, seed));
    }
}

