/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableRefCount$ConnectionSubscriber;
import io.reactivex.internal.operators.flowable.FlowableRefCount$DisposeConsumer;
import io.reactivex.internal.operators.flowable.FlowableRefCount$DisposeTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class FlowableRefCount<T>
extends AbstractFlowableWithUpstream<T, T> {
    final ConnectableFlowable<T> source;
    volatile CompositeDisposable baseDisposable = new CompositeDisposable();
    final AtomicInteger subscriptionCount = new AtomicInteger();
    final ReentrantLock lock = new ReentrantLock();

    public FlowableRefCount(ConnectableFlowable<T> source) {
        super(source);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeActual(Yx<? super T> subscriber) {
        this.lock.lock();
        if (this.subscriptionCount.incrementAndGet() == 1) {
            AtomicBoolean writeLocked = new AtomicBoolean(true);
            try {
                this.source.connect(this.onSubscribe(subscriber, writeLocked));
            }
            finally {
                if (writeLocked.get()) {
                    this.lock.unlock();
                }
            }
        }
        try {
            this.doSubscribe(subscriber, this.baseDisposable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Consumer<Disposable> onSubscribe(Yx<? super T> subscriber, AtomicBoolean writeLocked) {
        return new FlowableRefCount$DisposeConsumer(this, subscriber, writeLocked);
    }

    void doSubscribe(Yx<? super T> subscriber, CompositeDisposable currentBase) {
        Disposable d2 = this.disconnect(currentBase);
        FlowableRefCount$ConnectionSubscriber connection = new FlowableRefCount$ConnectionSubscriber(this, subscriber, currentBase, d2);
        subscriber.onSubscribe(connection);
        this.source.subscribe(connection);
    }

    private Disposable disconnect(CompositeDisposable current) {
        return Disposables.fromRunnable(new FlowableRefCount$DisposeTask(this, current));
    }
}

