/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.flowable.FlowableReplay$InnerSubscription;
import io.reactivex.internal.operators.flowable.FlowableReplay$ReplayBuffer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableReplay$ReplaySubscriber<T>
extends AtomicReference<Yy>
implements FlowableSubscriber<T>,
Disposable {
    private static final long serialVersionUID = 7224554242710036740L;
    final FlowableReplay$ReplayBuffer<T> buffer;
    boolean done;
    static final FlowableReplay$InnerSubscription[] EMPTY = new FlowableReplay$InnerSubscription[0];
    static final FlowableReplay$InnerSubscription[] TERMINATED = new FlowableReplay$InnerSubscription[0];
    final AtomicReference<FlowableReplay$InnerSubscription<T>[]> subscribers;
    final AtomicBoolean shouldConnect;
    final AtomicInteger management;
    long maxChildRequested;
    long maxUpstreamRequested;

    FlowableReplay$ReplaySubscriber(FlowableReplay$ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.management = new AtomicInteger();
        this.subscribers = new AtomicReference<FlowableReplay$InnerSubscription[]>(EMPTY);
        this.shouldConnect = new AtomicBoolean();
    }

    @Override
    public boolean isDisposed() {
        return this.subscribers.get() == TERMINATED;
    }

    @Override
    public void dispose() {
        this.subscribers.set(TERMINATED);
        SubscriptionHelper.cancel(this);
    }

    boolean add(FlowableReplay$InnerSubscription<T> producer) {
        FlowableReplay$InnerSubscription[] u2;
        FlowableReplay$InnerSubscription<T>[] c2;
        if (producer == null) {
            throw new NullPointerException();
        }
        do {
            if ((c2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = c2.length;
            u2 = new FlowableReplay$InnerSubscription[len + 1];
            System.arraycopy(c2, 0, u2, 0, len);
            u2[len] = producer;
        } while (!this.subscribers.compareAndSet(c2, u2));
        return true;
    }

    void remove(FlowableReplay$InnerSubscription<T> p2) {
        FlowableReplay$InnerSubscription[] u2;
        FlowableReplay$InnerSubscription<T>[] c2;
        do {
            int len;
            if ((len = (c2 = this.subscribers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (!c2[i2].equals(p2)) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                u2 = EMPTY;
                continue;
            }
            u2 = new FlowableReplay$InnerSubscription[len - 1];
            System.arraycopy(c2, 0, u2, 0, j2);
            System.arraycopy(c2, j2 + 1, u2, j2, len - j2 - 1);
        } while (!this.subscribers.compareAndSet(c2, u2));
    }

    @Override
    public void onSubscribe(Yy p2) {
        if (SubscriptionHelper.setOnce(this, p2)) {
            this.manageRequests();
            for (FlowableReplay$InnerSubscription<T> rp2 : this.subscribers.get()) {
                this.buffer.replay(rp2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.done) {
            this.buffer.next(t2);
            for (FlowableReplay$InnerSubscription<T> rp2 : this.subscribers.get()) {
                this.buffer.replay(rp2);
            }
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (!this.done) {
            this.done = true;
            this.buffer.error(e2);
            for (FlowableReplay$InnerSubscription rp2 : this.subscribers.getAndSet(TERMINATED)) {
                this.buffer.replay(rp2);
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.buffer.complete();
            for (FlowableReplay$InnerSubscription rp2 : this.subscribers.getAndSet(TERMINATED)) {
                this.buffer.replay(rp2);
            }
        }
    }

    void manageRequests() {
        if (this.management.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            long ri2;
            if (this.isDisposed()) {
                return;
            }
            FlowableReplay$InnerSubscription<T>[] a2 = this.subscribers.get();
            long maxTotalRequests = ri2 = this.maxChildRequested;
            for (FlowableReplay$InnerSubscription<T> rp2 : a2) {
                maxTotalRequests = Math.max(maxTotalRequests, rp2.totalRequested.get());
            }
            long ur2 = this.maxUpstreamRequested;
            Yy p2 = (Yy)this.get();
            long diff = maxTotalRequests - ri2;
            if (diff != 0L) {
                this.maxChildRequested = maxTotalRequests;
                if (p2 != null) {
                    if (ur2 != 0L) {
                        this.maxUpstreamRequested = 0L;
                        p2.request(ur2 + diff);
                        continue;
                    }
                    p2.request(diff);
                    continue;
                }
                long u2 = ur2 + diff;
                if (u2 < 0L) {
                    u2 = Long.MAX_VALUE;
                }
                this.maxUpstreamRequested = u2;
                continue;
            }
            if (ur2 == 0L || p2 == null) continue;
            this.maxUpstreamRequested = 0L;
            p2.request(ur2);
        } while ((missed = this.management.addAndGet(-missed)) != 0);
    }
}

