/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.operators.flowable.FlowableSamplePublisher$SamplerSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

abstract class FlowableSamplePublisher$SamplePublisherSubscriber<T>
extends AtomicReference<T>
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -3517602651313910099L;
    final Yx<? super T> actual;
    final Yw<?> sampler;
    final AtomicLong requested = new AtomicLong();
    final AtomicReference<Yy> other = new AtomicReference();
    Yy s;

    FlowableSamplePublisher$SamplePublisherSubscriber(Yx<? super T> actual, Yw<?> other) {
        this.actual = actual;
        this.sampler = other;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            if (this.other.get() == null) {
                this.sampler.subscribe(new FlowableSamplePublisher$SamplerSubscriber(this));
                s2.request(Long.MAX_VALUE);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        this.lazySet(t2);
    }

    @Override
    public void onError(Throwable t2) {
        SubscriptionHelper.cancel(this.other);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        SubscriptionHelper.cancel(this.other);
        this.completeMain();
    }

    boolean setOther(Yy o2) {
        return SubscriptionHelper.setOnce(this.other, o2);
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
        }
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this.other);
        this.s.cancel();
    }

    public void error(Throwable e2) {
        this.s.cancel();
        this.actual.onError(e2);
    }

    public void complete() {
        this.s.cancel();
        this.completeOther();
    }

    void emit() {
        Object value = this.getAndSet(null);
        if (value != null) {
            long r2 = this.requested.get();
            if (r2 != 0L) {
                this.actual.onNext(value);
                BackpressureHelper.produced(this.requested, 1L);
            } else {
                this.cancel();
                this.actual.onError(new MissingBackpressureException("Couldn't emit value due to lack of requests!"));
            }
        }
    }

    abstract void completeMain();

    abstract void completeOther();

    abstract void run();
}

