/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap$ScalarXMapFlowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.ScalarSubscription;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class FlowableScalarXMap {
    private FlowableScalarXMap() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, R> boolean tryScalarXMapSubscribe(Yw<T> source, Yx<? super R> subscriber, Function<? super T, ? extends Yw<? extends R>> mapper) {
        if (source instanceof Callable) {
            Yw<R> r2;
            Object t2;
            try {
                t2 = ((Callable)((Object)source)).call();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptySubscription.error(ex2, subscriber);
                return true;
            }
            if (t2 == null) {
                EmptySubscription.complete(subscriber);
                return true;
            }
            try {
                r2 = ObjectHelper.requireNonNull(mapper.apply(t2), "The mapper returned a null Publisher");
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                EmptySubscription.error(ex3, subscriber);
                return true;
            }
            if (r2 instanceof Callable) {
                Object u2;
                try {
                    u2 = ((Callable)((Object)r2)).call();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    EmptySubscription.error(ex4, subscriber);
                    return true;
                }
                if (u2 == null) {
                    EmptySubscription.complete(subscriber);
                    return true;
                }
                subscriber.onSubscribe(new ScalarSubscription<R>(subscriber, u2));
            } else {
                r2.subscribe(subscriber);
            }
            return true;
        }
        return false;
    }

    public static <T, U> Flowable<U> scalarXMap(T value, Function<? super T, ? extends Yw<? extends U>> mapper) {
        return RxJavaPlugins.onAssembly(new FlowableScalarXMap$ScalarXMapFlowable(value, mapper));
    }
}

