/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class FlowableScan$ScanSubscriber<T>
implements Yy,
FlowableSubscriber<T> {
    final Yx<? super T> actual;
    final BiFunction<T, T, T> accumulator;
    Yy s;
    T value;
    boolean done;

    FlowableScan$ScanSubscriber(Yx<? super T> actual, BiFunction<T, T, T> accumulator) {
        this.actual = actual;
        this.accumulator = accumulator;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        Yx<T> a2 = this.actual;
        T v2 = this.value;
        if (v2 == null) {
            this.value = t2;
            a2.onNext(t2);
        } else {
            T u2;
            try {
                u2 = ObjectHelper.requireNonNull(this.accumulator.apply(v2, t2), "The value returned by the accumulator is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.s.cancel();
                this.onError(e2);
                return;
            }
            this.value = u2;
            a2.onNext(u2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        this.s.request(n2);
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }
}

