/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableSequenceEqual$EqualCoordinatorHelper;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableSequenceEqual$EqualSubscriber<T>
extends AtomicReference<Yy>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = 4804128302091633067L;
    final FlowableSequenceEqual$EqualCoordinatorHelper parent;
    final int prefetch;
    final int limit;
    long produced;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    int sourceMode;

    FlowableSequenceEqual$EqualSubscriber(FlowableSequenceEqual$EqualCoordinatorHelper parent, int prefetch) {
        this.parent = parent;
        this.limit = prefetch - (prefetch >> 2);
        this.prefetch = prefetch;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(3);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    s2.request(this.prefetch);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.prefetch);
            s2.request(this.prefetch);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.sourceMode == 0 && !this.queue.offer(t2)) {
            this.onError(new MissingBackpressureException());
            return;
        }
        this.parent.drain();
    }

    @Override
    public void onError(Throwable t2) {
        this.parent.innerError(t2);
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.parent.drain();
    }

    public void request() {
        if (this.sourceMode != 1) {
            long p2 = this.produced + 1L;
            if (p2 >= (long)this.limit) {
                this.produced = 0L;
                ((Yy)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }
    }

    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    void clear() {
        SimpleQueue<T> sq2 = this.queue;
        if (sq2 != null) {
            sq2.clear();
        }
    }
}

