/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.internal.operators.flowable.FlowableSubscribeOn$SubscribeOnSubscriber$Request;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableSubscribeOn$SubscribeOnSubscriber<T>
extends AtomicReference<Thread>
implements Yy,
FlowableSubscriber<T>,
Runnable {
    private static final long serialVersionUID = 8094547886072529208L;
    final Yx<? super T> actual;
    final Scheduler$Worker worker;
    final AtomicReference<Yy> s;
    final AtomicLong requested;
    final boolean nonScheduledRequests;
    Yw<T> source;

    FlowableSubscribeOn$SubscribeOnSubscriber(Yx<? super T> actual, Scheduler$Worker worker, Yw<T> source, boolean requestOn) {
        this.actual = actual;
        this.worker = worker;
        this.source = source;
        this.s = new AtomicReference();
        this.requested = new AtomicLong();
        this.nonScheduledRequests = !requestOn;
    }

    @Override
    public void run() {
        this.lazySet(Thread.currentThread());
        Yw<T> src = this.source;
        this.source = null;
        src.subscribe(this);
    }

    @Override
    public void onSubscribe(Yy s2) {
        long r2;
        if (SubscriptionHelper.setOnce(this.s, s2) && (r2 = this.requested.getAndSet(0L)) != 0L) {
            this.requestUpstream(r2, s2);
        }
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
        this.worker.dispose();
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
        this.worker.dispose();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            Yy s2 = this.s.get();
            if (s2 != null) {
                this.requestUpstream(n2, s2);
            } else {
                long r2;
                BackpressureHelper.add(this.requested, n2);
                s2 = this.s.get();
                if (s2 != null && (r2 = this.requested.getAndSet(0L)) != 0L) {
                    this.requestUpstream(r2, s2);
                }
            }
        }
    }

    void requestUpstream(long n2, Yy s2) {
        if (this.nonScheduledRequests || Thread.currentThread() == this.get()) {
            s2.request(n2);
        } else {
            this.worker.schedule(new FlowableSubscribeOn$SubscribeOnSubscriber$Request(s2, n2));
        }
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this.s);
        this.worker.dispose();
    }
}

