/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableSwitchMap$SwitchMapSubscriber;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableSwitchMap$SwitchMapInnerSubscriber<T, R>
extends AtomicReference<Yy>
implements FlowableSubscriber<R> {
    private static final long serialVersionUID = 3837284832786408377L;
    final FlowableSwitchMap$SwitchMapSubscriber<T, R> parent;
    final long index;
    final int bufferSize;
    volatile SimpleQueue<R> queue;
    volatile boolean done;
    int fusionMode;

    FlowableSwitchMap$SwitchMapInnerSubscriber(FlowableSwitchMap$SwitchMapSubscriber<T, R> parent, long index, int bufferSize) {
        this.parent = parent;
        this.index = index;
        this.bufferSize = bufferSize;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(3);
                if (m2 == 1) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m2 == 2) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                    s2.request(this.bufferSize);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<R>(this.bufferSize);
            s2.request(this.bufferSize);
        }
    }

    @Override
    public void onNext(R t2) {
        FlowableSwitchMap$SwitchMapSubscriber<T, R> p2 = this.parent;
        if (this.index == p2.unique) {
            if (this.fusionMode == 0 && !this.queue.offer(t2)) {
                this.onError(new MissingBackpressureException("Queue full?!"));
                return;
            }
            p2.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        FlowableSwitchMap$SwitchMapSubscriber<T, R> p2 = this.parent;
        if (this.index == p2.unique && p2.error.addThrowable(t2)) {
            if (!p2.delayErrors) {
                p2.s.cancel();
            }
            this.done = true;
            p2.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        FlowableSwitchMap$SwitchMapSubscriber<T, R> p2 = this.parent;
        if (this.index == p2.unique) {
            this.done = true;
            p2.drain();
        }
    }

    public void cancel() {
        SubscriptionHelper.cancel(this);
    }
}

