/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableSwitchMap$SwitchMapInnerSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableSwitchMap$SwitchMapSubscriber<T, R>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -3491074160481096299L;
    final Yx<? super R> actual;
    final Function<? super T, ? extends Yw<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;
    volatile boolean done;
    final AtomicThrowable error;
    volatile boolean cancelled;
    Yy s;
    final AtomicReference<FlowableSwitchMap$SwitchMapInnerSubscriber<T, R>> active = new AtomicReference();
    final AtomicLong requested = new AtomicLong();
    static final FlowableSwitchMap$SwitchMapInnerSubscriber<Object, Object> CANCELLED = new FlowableSwitchMap$SwitchMapInnerSubscriber(null, -1L, 1);
    volatile long unique;

    FlowableSwitchMap$SwitchMapSubscriber(Yx<? super R> actual, Function<? super T, ? extends Yw<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        this.actual = actual;
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
        this.error = new AtomicThrowable();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        Yw<R> p2;
        long c2;
        if (this.done) {
            return;
        }
        this.unique = c2 = this.unique + 1L;
        FlowableSwitchMap$SwitchMapInnerSubscriber<T, R> inner = this.active.get();
        if (inner != null) {
            inner.cancel();
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The publisher returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.s.cancel();
            this.onError(e2);
            return;
        }
        FlowableSwitchMap$SwitchMapInnerSubscriber nextInner = new FlowableSwitchMap$SwitchMapInnerSubscriber(this, c2, this.bufferSize);
        while ((inner = this.active.get()) != CANCELLED) {
            if (!this.active.compareAndSet(inner, nextInner)) continue;
            p2.subscribe(nextInner);
            break;
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.done && this.error.addThrowable(t2)) {
            if (!this.delayErrors) {
                this.disposeInner();
            }
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            if (this.unique == 0L) {
                this.s.request(Long.MAX_VALUE);
            } else {
                this.drain();
            }
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.cancel();
            this.disposeInner();
        }
    }

    void disposeInner() {
        FlowableSwitchMap$SwitchMapInnerSubscriber<Object, Object> a2 = this.active.get();
        if (a2 != CANCELLED && (a2 = this.active.getAndSet(CANCELLED)) != CANCELLED && a2 != null) {
            a2.cancel();
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Yx<R> a2 = this.actual;
        int missing = 1;
        while (true) {
            FlowableSwitchMap$SwitchMapInnerSubscriber<T, R> inner;
            SimpleQueue q2;
            if (this.cancelled) {
                this.active.lazySet(null);
                return;
            }
            if (this.done) {
                Throwable err;
                if (this.delayErrors) {
                    if (this.active.get() == null) {
                        err = (Throwable)this.error.get();
                        if (err != null) {
                            a2.onError(this.error.terminate());
                        } else {
                            a2.onComplete();
                        }
                        return;
                    }
                } else {
                    err = (Throwable)this.error.get();
                    if (err != null) {
                        this.disposeInner();
                        a2.onError(this.error.terminate());
                        return;
                    }
                    if (this.active.get() == null) {
                        a2.onComplete();
                        return;
                    }
                }
            }
            SimpleQueue simpleQueue = q2 = (inner = this.active.get()) != null ? inner.queue : null;
            if (q2 != null) {
                long e2;
                if (inner.done) {
                    if (!this.delayErrors) {
                        Throwable err = (Throwable)this.error.get();
                        if (err != null) {
                            this.disposeInner();
                            a2.onError(this.error.terminate());
                            return;
                        }
                        if (q2.isEmpty()) {
                            this.active.compareAndSet(inner, null);
                            continue;
                        }
                    } else if (q2.isEmpty()) {
                        this.active.compareAndSet(inner, null);
                        continue;
                    }
                }
                long r2 = this.requested.get();
                boolean retry = false;
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty;
                    Object v2;
                    if (this.cancelled) {
                        return;
                    }
                    boolean d2 = inner.done;
                    try {
                        v2 = q2.poll();
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal(ex2);
                        inner.cancel();
                        this.error.addThrowable(ex2);
                        d2 = true;
                        v2 = null;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (inner != this.active.get()) {
                        retry = true;
                        break;
                    }
                    if (d2) {
                        if (!this.delayErrors) {
                            Throwable err = (Throwable)this.error.get();
                            if (err != null) {
                                a2.onError(this.error.terminate());
                                return;
                            }
                            if (empty) {
                                this.active.compareAndSet(inner, null);
                                retry = true;
                                break;
                            }
                        } else if (empty) {
                            this.active.compareAndSet(inner, null);
                            retry = true;
                            break;
                        }
                    }
                    if (empty) break;
                    a2.onNext(v2);
                }
                if (e2 != 0L && !this.cancelled) {
                    if (r2 != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e2);
                    }
                    ((Yy)inner.get()).request(e2);
                }
                if (retry) continue;
            }
            if ((missing = this.addAndGet(-missing)) == 0) break;
        }
    }

    static {
        CANCELLED.cancel();
    }
}

