/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableTimeout$TimeoutConsumer;
import io.reactivex.internal.operators.flowable.FlowableTimeout$TimeoutSelectorSupport;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableTimeout$TimeoutSubscriber<T>
extends AtomicLong
implements Yy,
FlowableSubscriber<T>,
FlowableTimeout$TimeoutSelectorSupport {
    private static final long serialVersionUID = 3764492702657003550L;
    final Yx<? super T> actual;
    final Function<? super T, ? extends Yw<?>> itemTimeoutIndicator;
    final SequentialDisposable task;
    final AtomicReference<Yy> upstream;
    final AtomicLong requested;

    FlowableTimeout$TimeoutSubscriber(Yx<? super T> actual, Function<? super T, ? extends Yw<?>> itemTimeoutIndicator) {
        this.actual = actual;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
        this.task = new SequentialDisposable();
        this.upstream = new AtomicReference();
        this.requested = new AtomicLong();
    }

    @Override
    public void onSubscribe(Yy s2) {
        SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
    }

    @Override
    public void onNext(T t2) {
        Yw<?> itemTimeoutPublisher;
        long idx = this.get();
        if (idx == Long.MAX_VALUE || !this.compareAndSet(idx, idx + 1L)) {
            return;
        }
        Disposable d2 = (Disposable)this.task.get();
        if (d2 != null) {
            d2.dispose();
        }
        this.actual.onNext(t2);
        try {
            itemTimeoutPublisher = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The itemTimeoutIndicator returned a null Publisher.");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.upstream.get().cancel();
            this.getAndSet(Long.MAX_VALUE);
            this.actual.onError(ex2);
            return;
        }
        FlowableTimeout$TimeoutConsumer consumer = new FlowableTimeout$TimeoutConsumer(idx + 1L, this);
        if (this.task.replace(consumer)) {
            itemTimeoutPublisher.subscribe(consumer);
        }
    }

    void startFirstTimeout(Yw<?> firstTimeoutIndicator) {
        FlowableTimeout$TimeoutConsumer consumer;
        if (firstTimeoutIndicator != null && this.task.replace(consumer = new FlowableTimeout$TimeoutConsumer(0L, this))) {
            firstTimeoutIndicator.subscribe(consumer);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onError(t2);
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onComplete();
        }
    }

    @Override
    public void onTimeout(long idx) {
        if (this.compareAndSet(idx, Long.MAX_VALUE)) {
            SubscriptionHelper.cancel(this.upstream);
            this.actual.onError(new TimeoutException());
        }
    }

    @Override
    public void onTimeoutError(long idx, Throwable ex2) {
        if (this.compareAndSet(idx, Long.MAX_VALUE)) {
            SubscriptionHelper.cancel(this.upstream);
            this.actual.onError(ex2);
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    @Override
    public void request(long n2) {
        SubscriptionHelper.deferredRequest(this.upstream, this.requested, n2);
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this.upstream);
        this.task.dispose();
    }
}

