/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed$FallbackSubscriber;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed$TimeoutSupport;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed$TimeoutTask;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableTimeoutTimed$TimeoutFallbackSubscriber<T>
extends SubscriptionArbiter
implements FlowableSubscriber<T>,
FlowableTimeoutTimed$TimeoutSupport {
    private static final long serialVersionUID = 3764492702657003550L;
    final Yx<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    final SequentialDisposable task;
    final AtomicReference<Yy> upstream;
    final AtomicLong index;
    long consumed;
    Yw<? extends T> fallback;

    FlowableTimeoutTimed$TimeoutFallbackSubscriber(Yx<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker, Yw<? extends T> fallback) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
        this.fallback = fallback;
        this.task = new SequentialDisposable();
        this.upstream = new AtomicReference();
        this.index = new AtomicLong();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.upstream, s2)) {
            this.setSubscription(s2);
        }
    }

    @Override
    public void onNext(T t2) {
        long idx = this.index.get();
        if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
            return;
        }
        ((Disposable)this.task.get()).dispose();
        ++this.consumed;
        this.actual.onNext(t2);
        this.startTimeout(idx + 1L);
    }

    void startTimeout(long nextIndex) {
        this.task.replace(this.worker.schedule(new FlowableTimeoutTimed$TimeoutTask(nextIndex, this), this.timeout, this.unit));
    }

    @Override
    public void onError(Throwable t2) {
        if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onError(t2);
            this.worker.dispose();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onComplete();
            this.worker.dispose();
        }
    }

    @Override
    public void onTimeout(long idx) {
        if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
            SubscriptionHelper.cancel(this.upstream);
            long c2 = this.consumed;
            if (c2 != 0L) {
                this.produced(c2);
            }
            Yw<? super T> f2 = this.fallback;
            this.fallback = null;
            f2.subscribe(new FlowableTimeoutTimed$FallbackSubscriber<T>(this.actual, this));
            this.worker.dispose();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.worker.dispose();
    }
}

