/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

final class FlowableUsing$UsingSubscriber<T, D>
extends AtomicBoolean
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 5904473792286235046L;
    final Yx<? super T> actual;
    final D resource;
    final Consumer<? super D> disposer;
    final boolean eager;
    Yy s;

    FlowableUsing$UsingSubscriber(Yx<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
        this.actual = actual;
        this.resource = resource;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.eager) {
            Throwable innerError = null;
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    innerError = e2;
                }
            }
            this.s.cancel();
            if (innerError != null) {
                this.actual.onError(new CompositeException(t2, innerError));
            } else {
                this.actual.onError(t2);
            }
        } else {
            this.actual.onError(t2);
            this.s.cancel();
            this.disposeAfter();
        }
    }

    @Override
    public void onComplete() {
        if (this.eager) {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    this.actual.onError(e2);
                    return;
                }
            }
            this.s.cancel();
            this.actual.onComplete();
        } else {
            this.actual.onComplete();
            this.s.cancel();
            this.disposeAfter();
        }
    }

    @Override
    public void request(long n2) {
        this.s.request(n2);
    }

    @Override
    public void cancel() {
        this.disposeAfter();
        this.s.cancel();
    }

    void disposeAfter() {
        if (this.compareAndSet(false, true)) {
            try {
                this.disposer.accept(this.resource);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RxJavaPlugins.onError(e2);
            }
        }
    }
}

