/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableUsing$UsingSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.concurrent.Callable;

public final class FlowableUsing<T, D>
extends Flowable<T> {
    final Callable<? extends D> resourceSupplier;
    final Function<? super D, ? extends Yw<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public FlowableUsing(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Yw<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        Yw<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptySubscription.error(e2, s2);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null Publisher");
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptySubscription.error(new CompositeException(e3, ex2), s2);
                return;
            }
            EmptySubscription.error(e3, s2);
            return;
        }
        FlowableUsing$UsingSubscriber<? super T, ? super D> us2 = new FlowableUsing$UsingSubscriber<T, D>(s2, resource, this.disposer, this.eager);
        source.subscribe(us2);
    }
}

