/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.processors.UnicastProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class FlowableWindow$WindowExactSubscriber<T>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T>,
Runnable {
    private static final long serialVersionUID = -2365647875069161133L;
    final Yx<? super Flowable<T>> actual;
    final long size;
    final AtomicBoolean once;
    final int bufferSize;
    long index;
    Yy s;
    UnicastProcessor<T> window;

    FlowableWindow$WindowExactSubscriber(Yx<? super Flowable<T>> actual, long size, int bufferSize) {
        super(1);
        this.actual = actual;
        this.size = size;
        this.once = new AtomicBoolean();
        this.bufferSize = bufferSize;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        long i2 = this.index;
        UnicastProcessor<T> w2 = this.window;
        if (i2 == 0L) {
            this.getAndIncrement();
            w2 = UnicastProcessor.create(this.bufferSize, this);
            this.window = w2;
            this.actual.onNext(w2);
        }
        w2.onNext(t2);
        if (++i2 == this.size) {
            this.index = 0L;
            this.window = null;
            w2.onComplete();
        } else {
            this.index = i2;
        }
    }

    @Override
    public void onError(Throwable t2) {
        UnicastProcessor<T> w2 = this.window;
        if (w2 != null) {
            this.window = null;
            w2.onError(t2);
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        UnicastProcessor<T> w2 = this.window;
        if (w2 != null) {
            this.window = null;
            w2.onComplete();
        }
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            long u2 = BackpressureHelper.multiplyCap(this.size, n2);
            this.s.request(u2);
        }
    }

    @Override
    public void cancel() {
        if (this.once.compareAndSet(false, true)) {
            this.run();
        }
    }

    @Override
    public void run() {
        if (this.decrementAndGet() == 0) {
            this.s.cancel();
        }
    }
}

