/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.processors.UnicastProcessor;
import java.util.concurrent.TimeUnit;

final class FlowableWindowTimed$WindowExactBoundedSubscriber<T>
extends QueueDrainSubscriber<T, Object, Flowable<T>>
implements Yy {
    final long timespan;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean restartTimerOnMaxSize;
    final long maxSize;
    final Scheduler$Worker worker;
    long count;
    long producerIndex;
    Yy s;
    UnicastProcessor<T> window;
    volatile boolean terminated;
    final SequentialDisposable timer = new SequentialDisposable();

    FlowableWindowTimed$WindowExactBoundedSubscriber(Yx<? super Flowable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
        super(actual, new MpscLinkedQueue());
        this.timespan = timespan;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
        this.worker = restartTimerOnMaxSize ? scheduler.createWorker() : null;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            Yx a2 = this.actual;
            a2.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            UnicastProcessor w2 = UnicastProcessor.create(this.bufferSize);
            this.window = w2;
            long r2 = this.requested();
            if (r2 != 0L) {
                a2.onNext(w2);
                if (r2 != Long.MAX_VALUE) {
                    this.produced(1L);
                }
            } else {
                this.cancelled = true;
                s2.cancel();
                a2.onError(new MissingBackpressureException("Could not deliver initial window due to lack of requests."));
                return;
            }
            FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder consumerIndexHolder = new FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder(this.producerIndex, this);
            Disposable d2 = this.restartTimerOnMaxSize ? this.worker.schedulePeriodically(consumerIndexHolder, this.timespan, this.timespan, this.unit) : this.scheduler.schedulePeriodicallyDirect(consumerIndexHolder, this.timespan, this.timespan, this.unit);
            if (this.timer.replace(d2)) {
                s2.request(Long.MAX_VALUE);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onNext(T t2) {
        block10: {
            block7: {
                block9: {
                    long c2;
                    block8: {
                        if (this.terminated) {
                            return;
                        }
                        if (!this.fastEnter()) break block7;
                        UnicastProcessor<T> w2 = this.window;
                        w2.onNext(t2);
                        c2 = this.count + 1L;
                        if (c2 < this.maxSize) break block8;
                        ++this.producerIndex;
                        this.count = 0L;
                        w2.onComplete();
                        long r2 = this.requested();
                        if (r2 == 0L) {
                            this.window = null;
                            this.s.cancel();
                            this.actual.onError(new MissingBackpressureException("Could not deliver window due to lack of requests"));
                            this.dispose();
                            return;
                        }
                        w2 = UnicastProcessor.create(this.bufferSize);
                        this.window = w2;
                        this.actual.onNext(w2);
                        if (r2 != Long.MAX_VALUE) {
                            this.produced(1L);
                        }
                        if (this.restartTimerOnMaxSize) {
                            Disposable tm2 = (Disposable)this.timer.get();
                            tm2.dispose();
                            Disposable task = this.worker.schedulePeriodically(new FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                            if (!this.timer.compareAndSet(tm2, task)) {
                                task.dispose();
                            }
                        }
                        break block9;
                    }
                    this.count = c2;
                }
                if (this.leave(-1) == 0) {
                    return;
                }
                break block10;
            }
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onError(t2);
        this.dispose();
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onComplete();
        this.dispose();
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void dispose() {
        DisposableHelper.dispose(this.timer);
        Scheduler$Worker w2 = this.worker;
        if (w2 != null) {
            w2.dispose();
        }
    }

    void drainLoop() {
        SimplePlainQueue q2 = this.queue;
        Yx a2 = this.actual;
        UnicastProcessor w2 = this.window;
        int missed = 1;
        while (true) {
            if (this.terminated) {
                this.s.cancel();
                q2.clear();
                this.dispose();
                return;
            }
            boolean d2 = this.done;
            Object o2 = q2.poll();
            boolean empty = o2 == null;
            boolean isHolder = o2 instanceof FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder;
            if (d2 && (empty || isHolder)) {
                this.window = null;
                q2.clear();
                Throwable err = this.error;
                if (err != null) {
                    w2.onError(err);
                } else {
                    w2.onComplete();
                }
                this.dispose();
                return;
            }
            if (!empty) {
                if (isHolder) {
                    FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder consumerIndexHolder = (FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder)o2;
                    if (!this.restartTimerOnMaxSize && this.producerIndex != consumerIndexHolder.index) continue;
                    w2.onComplete();
                    this.count = 0L;
                    w2 = UnicastProcessor.create(this.bufferSize);
                    this.window = w2;
                    long r2 = this.requested();
                    if (r2 != 0L) {
                        a2.onNext(w2);
                        if (r2 == Long.MAX_VALUE) continue;
                        this.produced(1L);
                        continue;
                    }
                    this.window = null;
                    this.queue.clear();
                    this.s.cancel();
                    a2.onError(new MissingBackpressureException("Could not deliver first window due to lack of requests."));
                    this.dispose();
                    return;
                }
                w2.onNext(NotificationLite.getValue(o2));
                long c2 = this.count + 1L;
                if (c2 >= this.maxSize) {
                    ++this.producerIndex;
                    this.count = 0L;
                    w2.onComplete();
                    long r3 = this.requested();
                    if (r3 != 0L) {
                        w2 = UnicastProcessor.create(this.bufferSize);
                        this.window = w2;
                        this.actual.onNext(w2);
                        if (r3 != Long.MAX_VALUE) {
                            this.produced(1L);
                        }
                        if (!this.restartTimerOnMaxSize) continue;
                        Disposable tm2 = (Disposable)this.timer.get();
                        tm2.dispose();
                        Disposable task = this.worker.schedulePeriodically(new FlowableWindowTimed$WindowExactBoundedSubscriber$ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                        if (this.timer.compareAndSet(tm2, task)) continue;
                        task.dispose();
                        continue;
                    }
                    this.window = null;
                    this.s.cancel();
                    this.actual.onError(new MissingBackpressureException("Could not deliver window due to lack of requests"));
                    this.dispose();
                    return;
                }
                this.count = c2;
                continue;
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    static /* synthetic */ boolean access$000(FlowableWindowTimed$WindowExactBoundedSubscriber x0) {
        return x0.cancelled;
    }

    static /* synthetic */ SimplePlainQueue access$100(FlowableWindowTimed$WindowExactBoundedSubscriber x0) {
        return x0.queue;
    }
}

