/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Scheduler$Worker;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.FlowableWindowTimed$WindowSkipSubscriber$Completion;
import io.reactivex.internal.operators.flowable.FlowableWindowTimed$WindowSkipSubscriber$SubjectWork;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.processors.UnicastProcessor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class FlowableWindowTimed$WindowSkipSubscriber<T>
extends QueueDrainSubscriber<T, Object, Flowable<T>>
implements Yy,
Runnable {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    final int bufferSize;
    final List<UnicastProcessor<T>> windows;
    Yy s;
    volatile boolean terminated;

    FlowableWindowTimed$WindowSkipSubscriber(Yx<? super Flowable<T>> actual, long timespan, long timeskip, TimeUnit unit, Scheduler$Worker worker, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.worker = worker;
        this.bufferSize = bufferSize;
        this.windows = new LinkedList<UnicastProcessor<T>>();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            long r2 = this.requested();
            if (r2 != 0L) {
                UnicastProcessor w2 = UnicastProcessor.create(this.bufferSize);
                this.windows.add(w2);
                this.actual.onNext(w2);
                if (r2 != Long.MAX_VALUE) {
                    this.produced(1L);
                }
                this.worker.schedule(new FlowableWindowTimed$WindowSkipSubscriber$Completion(this, w2), this.timespan, this.unit);
                this.worker.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
                s2.request(Long.MAX_VALUE);
            } else {
                s2.cancel();
                this.actual.onError(new MissingBackpressureException("Could not emit the first window due to lack of requests"));
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.fastEnter()) {
            for (UnicastProcessor<T> w2 : this.windows) {
                w2.onNext(t2);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(t2);
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onError(t2);
        this.dispose();
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onComplete();
        this.dispose();
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void dispose() {
        this.worker.dispose();
    }

    void complete(UnicastProcessor<T> w2) {
        this.queue.offer(new FlowableWindowTimed$WindowSkipSubscriber$SubjectWork<T>(w2, false));
        if (this.enter()) {
            this.drainLoop();
        }
    }

    void drainLoop() {
        SimplePlainQueue q2 = this.queue;
        Yx a2 = this.actual;
        List<UnicastProcessor<T>> ws2 = this.windows;
        int missed = 1;
        block0: while (true) {
            if (this.terminated) {
                this.s.cancel();
                this.dispose();
                q2.clear();
                ws2.clear();
                return;
            }
            boolean d2 = this.done;
            Object v2 = q2.poll();
            boolean empty = v2 == null;
            boolean sw2 = v2 instanceof FlowableWindowTimed$WindowSkipSubscriber$SubjectWork;
            if (d2 && (empty || sw2)) {
                q2.clear();
                Throwable e2 = this.error;
                if (e2 != null) {
                    for (UnicastProcessor<T> w2 : ws2) {
                        w2.onError(e2);
                    }
                } else {
                    for (UnicastProcessor<T> w3 : ws2) {
                        w3.onComplete();
                    }
                }
                ws2.clear();
                this.dispose();
                return;
            }
            if (!empty) {
                if (sw2) {
                    FlowableWindowTimed$WindowSkipSubscriber$SubjectWork work = (FlowableWindowTimed$WindowSkipSubscriber$SubjectWork)v2;
                    if (work.open) {
                        if (this.cancelled) continue;
                        long r2 = this.requested();
                        if (r2 != 0L) {
                            UnicastProcessor w4 = UnicastProcessor.create(this.bufferSize);
                            ws2.add(w4);
                            a2.onNext(w4);
                            if (r2 != Long.MAX_VALUE) {
                                this.produced(1L);
                            }
                            this.worker.schedule(new FlowableWindowTimed$WindowSkipSubscriber$Completion(this, w4), this.timespan, this.unit);
                            continue;
                        }
                        a2.onError(new MissingBackpressureException("Can't emit window due to lack of requests"));
                        continue;
                    }
                    ws2.remove(work.w);
                    work.w.onComplete();
                    if (!ws2.isEmpty() || !this.cancelled) continue;
                    this.terminated = true;
                    continue;
                }
                Iterator<UnicastProcessor<T>> iterator = ws2.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    UnicastProcessor w5 = iterator.next();
                    w5.onNext(v2);
                }
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    @Override
    public void run() {
        UnicastProcessor w2 = UnicastProcessor.create(this.bufferSize);
        FlowableWindowTimed$WindowSkipSubscriber$SubjectWork sw2 = new FlowableWindowTimed$WindowSkipSubscriber$SubjectWork(w2, true);
        if (!this.cancelled) {
            this.queue.offer(sw2);
        }
        if (this.enter()) {
            this.drainLoop();
        }
    }
}

