/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableWithLatestFrom$WithLatestFromSubscriber<T, U, R>
extends AtomicReference<U>
implements Yy,
ConditionalSubscriber<T> {
    private static final long serialVersionUID = -312246233408980075L;
    final Yx<? super R> actual;
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final AtomicReference<Yy> s = new AtomicReference();
    final AtomicLong requested = new AtomicLong();
    final AtomicReference<Yy> other = new AtomicReference();

    FlowableWithLatestFrom$WithLatestFromSubscriber(Yx<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
        this.actual = actual;
        this.combiner = combiner;
    }

    @Override
    public void onSubscribe(Yy s2) {
        SubscriptionHelper.deferredSetOnce(this.s, this.requested, s2);
    }

    @Override
    public void onNext(T t2) {
        if (!this.tryOnNext(t2)) {
            this.s.get().request(1L);
        }
    }

    @Override
    public boolean tryOnNext(T t2) {
        Object u2 = this.get();
        if (u2 != null) {
            R r2;
            try {
                r2 = ObjectHelper.requireNonNull(this.combiner.apply(t2, u2), "The combiner returned a null value");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancel();
                this.actual.onError(e2);
                return false;
            }
            this.actual.onNext(r2);
            return true;
        }
        return false;
    }

    @Override
    public void onError(Throwable t2) {
        SubscriptionHelper.cancel(this.other);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        SubscriptionHelper.cancel(this.other);
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        SubscriptionHelper.deferredRequest(this.s, this.requested, n2);
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this.s);
        SubscriptionHelper.cancel(this.other);
    }

    public boolean setOther(Yy o2) {
        return SubscriptionHelper.setOnce(this.other, o2);
    }

    public void otherError(Throwable e2) {
        SubscriptionHelper.cancel(this.s);
        this.actual.onError(e2);
    }
}

