/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableMap;
import io.reactivex.internal.operators.flowable.FlowableWithLatestFromMany$SingletonArrayFunc;
import io.reactivex.internal.operators.flowable.FlowableWithLatestFromMany$WithLatestFromSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Arrays;

public final class FlowableWithLatestFromMany<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    @Nullable
    final Yw<?>[] otherArray;
    @Nullable
    final Iterable<? extends Yw<?>> otherIterable;
    final Function<? super Object[], R> combiner;

    public FlowableWithLatestFromMany(@NonNull Flowable<T> source, @NonNull Yw<?>[] otherArray, Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = otherArray;
        this.otherIterable = null;
        this.combiner = combiner;
    }

    public FlowableWithLatestFromMany(@NonNull Flowable<T> source, @NonNull Iterable<? extends Yw<?>> otherIterable, @NonNull Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = null;
        this.otherIterable = otherIterable;
        this.combiner = combiner;
    }

    @Override
    public void subscribeActual(Yx<? super R> s2) {
        Yw<?>[] others = this.otherArray;
        int n2 = 0;
        if (others == null) {
            others = new Yw[8];
            try {
                for (Yw<?> p2 : this.otherIterable) {
                    if (n2 == others.length) {
                        others = Arrays.copyOf(others, n2 + (n2 >> 1));
                    }
                    others[n2++] = p2;
                }
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptySubscription.error(ex2, s2);
                return;
            }
        } else {
            n2 = others.length;
        }
        if (n2 == 0) {
            new FlowableMap(this.source, new FlowableWithLatestFromMany$SingletonArrayFunc(this)).subscribeActual(s2);
            return;
        }
        FlowableWithLatestFromMany$WithLatestFromSubscriber parent = new FlowableWithLatestFromMany$WithLatestFromSubscriber(s2, this.combiner, n2);
        s2.onSubscribe(parent);
        parent.subscribe(others, n2);
        this.source.subscribe(parent);
    }
}

