/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableZip$ZipSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableZip$ZipCoordinator<T, R>
extends AtomicInteger
implements Yy {
    private static final long serialVersionUID = -2434867452883857743L;
    final Yx<? super R> actual;
    final FlowableZip$ZipSubscriber<T, R>[] subscribers;
    final Function<? super Object[], ? extends R> zipper;
    final AtomicLong requested;
    final AtomicThrowable errors;
    final boolean delayErrors;
    volatile boolean cancelled;
    final Object[] current;

    FlowableZip$ZipCoordinator(Yx<? super R> actual, Function<? super Object[], ? extends R> zipper, int n2, int prefetch, boolean delayErrors) {
        this.actual = actual;
        this.zipper = zipper;
        this.delayErrors = delayErrors;
        FlowableZip$ZipSubscriber[] a2 = new FlowableZip$ZipSubscriber[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            a2[i2] = new FlowableZip$ZipSubscriber(this, prefetch);
        }
        this.current = new Object[n2];
        this.subscribers = a2;
        this.requested = new AtomicLong();
        this.errors = new AtomicThrowable();
    }

    void subscribe(Yw<? extends T>[] sources, int n2) {
        FlowableZip$ZipSubscriber<T, R>[] a2 = this.subscribers;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.cancelled || !this.delayErrors && this.errors.get() != null) {
                return;
            }
            sources[i2].subscribe(a2[i2]);
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.cancelAll();
        }
    }

    void error(FlowableZip$ZipSubscriber<T, R> inner, Throwable e2) {
        if (this.errors.addThrowable(e2)) {
            inner.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    void cancelAll() {
        for (FlowableZip$ZipSubscriber<T, R> s2 : this.subscribers) {
            s2.cancel();
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Yx<R> a2 = this.actual;
        FlowableZip$ZipSubscriber<T, R>[] qs2 = this.subscribers;
        int n2 = qs2.length;
        Object[] values = this.current;
        int missed = 1;
        do {
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; r2 != e2; ++e2) {
                R v2;
                if (this.cancelled) {
                    return;
                }
                if (!this.delayErrors && this.errors.get() != null) {
                    this.cancelAll();
                    a2.onError(this.errors.terminate());
                    return;
                }
                boolean empty = false;
                for (int j2 = 0; j2 < n2; ++j2) {
                    FlowableZip$ZipSubscriber<T, R> inner = qs2[j2];
                    if (values[j2] != null) continue;
                    try {
                        boolean sourceEmpty;
                        boolean d2 = inner.done;
                        SimpleQueue q2 = inner.queue;
                        Object v3 = q2 != null ? q2.poll() : null;
                        boolean bl2 = sourceEmpty = v3 == null;
                        if (d2 && sourceEmpty) {
                            this.cancelAll();
                            Throwable ex2 = (Throwable)this.errors.get();
                            if (ex2 != null) {
                                a2.onError(this.errors.terminate());
                            } else {
                                a2.onComplete();
                            }
                            return;
                        }
                        if (!sourceEmpty) {
                            values[j2] = v3;
                            continue;
                        }
                        empty = true;
                        continue;
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        this.errors.addThrowable(ex3);
                        if (!this.delayErrors) {
                            this.cancelAll();
                            a2.onError(this.errors.terminate());
                            return;
                        }
                        empty = true;
                    }
                }
                if (empty) break;
                try {
                    v2 = ObjectHelper.requireNonNull(this.zipper.apply((Object[])values.clone()), "The zipper returned a null value");
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.cancelAll();
                    this.errors.addThrowable(ex4);
                    a2.onError(this.errors.terminate());
                    return;
                }
                a2.onNext(v2);
                Arrays.fill(values, null);
            }
            if (r2 == e2) {
                if (this.cancelled) {
                    return;
                }
                if (!this.delayErrors && this.errors.get() != null) {
                    this.cancelAll();
                    a2.onError(this.errors.terminate());
                    return;
                }
                for (int j3 = 0; j3 < n2; ++j3) {
                    FlowableZip$ZipSubscriber<T, R> inner = qs2[j3];
                    if (values[j3] != null) continue;
                    try {
                        boolean empty;
                        boolean d3 = inner.done;
                        SimpleQueue q3 = inner.queue;
                        Object v4 = q3 != null ? q3.poll() : null;
                        boolean bl3 = empty = v4 == null;
                        if (d3 && empty) {
                            this.cancelAll();
                            Throwable ex5 = (Throwable)this.errors.get();
                            if (ex5 != null) {
                                a2.onError(this.errors.terminate());
                            } else {
                                a2.onComplete();
                            }
                            return;
                        }
                        if (empty) continue;
                        values[j3] = v4;
                        continue;
                    }
                    catch (Throwable ex6) {
                        Exceptions.throwIfFatal(ex6);
                        this.errors.addThrowable(ex6);
                        if (this.delayErrors) continue;
                        this.cancelAll();
                        a2.onError(this.errors.terminate());
                        return;
                    }
                }
            }
            if (e2 == 0L) continue;
            for (FlowableZip$ZipSubscriber<T, R> inner : qs2) {
                inner.request(e2);
            }
            if (r2 == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

