/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.maybe.MaybeAmb$AmbMaybeObserver;

public final class MaybeAmb<T>
extends Maybe<T> {
    private final MaybeSource<? extends T>[] sources;
    private final Iterable<? extends MaybeSource<? extends T>> sourcesIterable;

    public MaybeAmb(MaybeSource<? extends T>[] sources, Iterable<? extends MaybeSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void subscribeActual(MaybeObserver<? super T> observer) {
        void var5_8;
        MaybeSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new MaybeSource[8];
            try {
                for (MaybeSource<? extends T> maybeSource : this.sourcesIterable) {
                    if (maybeSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                        return;
                    }
                    if (count == sources.length) {
                        MaybeSource[] b2 = new MaybeSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b2, 0, count);
                        sources = b2;
                    }
                    sources[count++] = maybeSource;
                }
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                EmptyDisposable.error(e2, observer);
                return;
            }
        } else {
            count = sources.length;
        }
        MaybeAmb$AmbMaybeObserver<T> parent = new MaybeAmb$AmbMaybeObserver<T>(observer);
        observer.onSubscribe(parent);
        boolean bl2 = false;
        while (var5_8 < count) {
            MaybeSource<T> s2 = sources[var5_8];
            if (parent.isDisposed()) {
                return;
            }
            if (s2 == null) {
                parent.onError(new NullPointerException("One of the MaybeSources is null"));
                return;
            }
            s2.subscribe(parent);
            ++var5_8;
        }
        if (count == 0) {
            observer.onComplete();
        }
    }
}

