/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.maybe.MaybeCache$CacheDisposable;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeCache<T>
extends Maybe<T>
implements MaybeObserver<T> {
    static final MaybeCache$CacheDisposable[] EMPTY = new MaybeCache$CacheDisposable[0];
    static final MaybeCache$CacheDisposable[] TERMINATED = new MaybeCache$CacheDisposable[0];
    final AtomicReference<MaybeSource<T>> source;
    final AtomicReference<MaybeCache$CacheDisposable<T>[]> observers;
    T value;
    Throwable error;

    public MaybeCache(MaybeSource<T> source) {
        this.source = new AtomicReference<MaybeSource<T>>(source);
        this.observers = new AtomicReference<MaybeCache$CacheDisposable[]>(EMPTY);
    }

    @Override
    public void subscribeActual(MaybeObserver<? super T> observer) {
        MaybeCache$CacheDisposable<T> parent = new MaybeCache$CacheDisposable<T>(observer, this);
        observer.onSubscribe(parent);
        if (this.add(parent)) {
            if (parent.isDisposed()) {
                this.remove(parent);
                return;
            }
        } else {
            if (!parent.isDisposed()) {
                Throwable ex2 = this.error;
                if (ex2 != null) {
                    observer.onError(ex2);
                } else {
                    T v2 = this.value;
                    if (v2 != null) {
                        observer.onSuccess(v2);
                    } else {
                        observer.onComplete();
                    }
                }
            }
            return;
        }
        MaybeSource src = this.source.getAndSet(null);
        if (src != null) {
            src.subscribe(this);
        }
    }

    @Override
    public void onSubscribe(Disposable d2) {
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        for (MaybeCache$CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.actual.onSuccess(value);
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.error = e2;
        for (MaybeCache$CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.actual.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        for (MaybeCache$CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.actual.onComplete();
        }
    }

    boolean add(MaybeCache$CacheDisposable<T> inner) {
        MaybeCache$CacheDisposable[] b2;
        MaybeCache$CacheDisposable<T>[] a2;
        do {
            if ((a2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new MaybeCache$CacheDisposable[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = inner;
        } while (!this.observers.compareAndSet(a2, b2));
        return true;
    }

    void remove(MaybeCache$CacheDisposable<T> inner) {
        MaybeCache$CacheDisposable[] b2;
        MaybeCache$CacheDisposable<T>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != inner) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new MaybeCache$CacheDisposable[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.observers.compareAndSet(a2, b2));
    }
}

