/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeConcatArray$ConcatMaybeObserver<T>
extends AtomicInteger
implements Yy,
MaybeObserver<T> {
    private static final long serialVersionUID = 3520831347801429610L;
    final Yx<? super T> actual;
    final AtomicLong requested;
    final AtomicReference<Object> current;
    final SequentialDisposable disposables;
    final MaybeSource<? extends T>[] sources;
    int index;
    long produced;

    MaybeConcatArray$ConcatMaybeObserver(Yx<? super T> actual, MaybeSource<? extends T>[] sources) {
        this.actual = actual;
        this.sources = sources;
        this.requested = new AtomicLong();
        this.disposables = new SequentialDisposable();
        this.current = new AtomicReference<NotificationLite>(NotificationLite.COMPLETE);
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        this.disposables.dispose();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        this.disposables.replace(d2);
    }

    @Override
    public void onSuccess(T value) {
        this.current.lazySet(value);
        this.drain();
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.current.lazySet((Object)NotificationLite.COMPLETE);
        this.drain();
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        AtomicReference<Object> c2 = this.current;
        Yx<Object> a2 = this.actual;
        SequentialDisposable cancelled = this.disposables;
        do {
            boolean goNextSource;
            if (cancelled.isDisposed()) {
                c2.lazySet(null);
                return;
            }
            Object o2 = c2.get();
            if (o2 == null) continue;
            if (o2 != NotificationLite.COMPLETE) {
                long p2 = this.produced;
                if (p2 != this.requested.get()) {
                    this.produced = p2 + 1L;
                    c2.lazySet(null);
                    goNextSource = true;
                    a2.onNext(o2);
                } else {
                    goNextSource = false;
                }
            } else {
                goNextSource = true;
                c2.lazySet(null);
            }
            if (!goNextSource || cancelled.isDisposed()) continue;
            int i2 = this.index;
            if (i2 == this.sources.length) {
                a2.onComplete();
                return;
            }
            this.index = i2 + 1;
            this.sources[i2].subscribe(this);
        } while (this.decrementAndGet() != 0);
    }
}

