/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeDelay$DelayMaybeObserver<T>
extends AtomicReference<Disposable>
implements MaybeObserver<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = 5566860102500855068L;
    final MaybeObserver<? super T> actual;
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    T value;
    Throwable error;

    MaybeDelay$DelayMaybeObserver(MaybeObserver<? super T> actual, long delay, TimeUnit unit, Scheduler scheduler) {
        this.actual = actual;
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        Throwable ex2 = this.error;
        if (ex2 != null) {
            this.actual.onError(ex2);
        } else {
            T v2 = this.value;
            if (v2 != null) {
                this.actual.onSuccess(v2);
            } else {
                this.actual.onComplete();
            }
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        this.schedule();
    }

    @Override
    public void onError(Throwable e2) {
        this.error = e2;
        this.schedule();
    }

    @Override
    public void onComplete() {
        this.schedule();
    }

    void schedule() {
        DisposableHelper.replace(this, this.scheduler.scheduleDirect(this, this.delay, this.unit));
    }
}

