/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeSource;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.maybe.MaybeEqualSingle$EqualObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class MaybeEqualSingle$EqualCoordinator<T>
extends AtomicInteger
implements Disposable {
    final SingleObserver<? super Boolean> actual;
    final MaybeEqualSingle$EqualObserver<T> observer1;
    final MaybeEqualSingle$EqualObserver<T> observer2;
    final BiPredicate<? super T, ? super T> isEqual;

    MaybeEqualSingle$EqualCoordinator(SingleObserver<? super Boolean> actual, BiPredicate<? super T, ? super T> isEqual) {
        super(2);
        this.actual = actual;
        this.isEqual = isEqual;
        this.observer1 = new MaybeEqualSingle$EqualObserver(this);
        this.observer2 = new MaybeEqualSingle$EqualObserver(this);
    }

    void subscribe(MaybeSource<? extends T> source1, MaybeSource<? extends T> source2) {
        source1.subscribe(this.observer1);
        source2.subscribe(this.observer2);
    }

    @Override
    public void dispose() {
        this.observer1.dispose();
        this.observer2.dispose();
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.observer1.get());
    }

    void done() {
        if (this.decrementAndGet() == 0) {
            Object o1 = this.observer1.value;
            Object o2 = this.observer2.value;
            if (o1 != null && o2 != null) {
                boolean b2;
                try {
                    b2 = this.isEqual.test(o1, o2);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.actual.onError(ex2);
                    return;
                }
                this.actual.onSuccess((Boolean)b2);
            } else {
                this.actual.onSuccess((Boolean)(o1 == null && o2 == null ? 1 : 0));
            }
        }
    }

    void error(MaybeEqualSingle$EqualObserver<T> sender, Throwable ex2) {
        if (this.getAndSet(0) > 0) {
            if (sender == this.observer1) {
                this.observer2.dispose();
            } else {
                this.observer1.dispose();
            }
            this.actual.onError(ex2);
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }
}

