/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;

final class MaybeFilterSingle$FilterMaybeObserver<T>
implements SingleObserver<T>,
Disposable {
    final MaybeObserver<? super T> actual;
    final Predicate<? super T> predicate;
    Disposable d;

    MaybeFilterSingle$FilterMaybeObserver(MaybeObserver<? super T> actual, Predicate<? super T> predicate) {
        this.actual = actual;
        this.predicate = predicate;
    }

    @Override
    public void dispose() {
        Disposable d2 = this.d;
        this.d = DisposableHelper.DISPOSED;
        d2.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        boolean b2;
        try {
            b2 = this.predicate.test(value);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(ex2);
            return;
        }
        if (b2) {
            this.actual.onSuccess(value);
        } else {
            this.actual.onComplete();
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }
}

