/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

final class MaybeFlatMapIterableFlowable$FlatMapIterableObserver<T, R>
extends BasicIntQueueSubscription<R>
implements MaybeObserver<T> {
    private static final long serialVersionUID = -8938804753851907758L;
    final Yx<? super R> actual;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final AtomicLong requested;
    Disposable d;
    volatile Iterator<? extends R> it;
    volatile boolean cancelled;
    boolean outputFused;

    MaybeFlatMapIterableFlowable$FlatMapIterableObserver(Yx<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.actual = actual;
        this.mapper = mapper;
        this.requested = new AtomicLong();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        boolean has;
        Iterator<R> iterator;
        try {
            iterator = this.mapper.apply(value).iterator();
            has = iterator.hasNext();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(ex2);
            return;
        }
        if (!has) {
            this.actual.onComplete();
            return;
        }
        this.it = iterator;
        this.drain();
    }

    @Override
    public void onError(Throwable e2) {
        this.d = DisposableHelper.DISPOSED;
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
    }

    void fastPath(Yx<? super R> a2, Iterator<? extends R> iterator) {
        boolean b2;
        do {
            R v2;
            if (this.cancelled) {
                return;
            }
            try {
                v2 = iterator.next();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                a2.onError(ex2);
                return;
            }
            a2.onNext(v2);
            if (this.cancelled) {
                return;
            }
            try {
                b2 = iterator.hasNext();
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                a2.onError(ex3);
                return;
            }
        } while (b2);
        a2.onComplete();
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Yx<R> a2 = this.actual;
        Iterator<R> iterator = this.it;
        if (this.outputFused && iterator != null) {
            a2.onNext(null);
            a2.onComplete();
            return;
        }
        int missed = 1;
        while (true) {
            if (iterator != null) {
                long e2;
                long r2 = this.requested.get();
                if (r2 == Long.MAX_VALUE) {
                    this.fastPath(a2, iterator);
                    return;
                }
                for (e2 = 0L; e2 != r2; ++e2) {
                    R v2;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        v2 = ObjectHelper.requireNonNull(iterator.next(), "The iterator returned a null value");
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal(ex2);
                        a2.onError(ex2);
                        return;
                    }
                    a2.onNext(v2);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        boolean b2 = iterator.hasNext();
                        continue;
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        a2.onError(ex3);
                        return;
                    }
                }
                if (e2 != 0L) {
                    BackpressureHelper.produced(this.requested, e2);
                }
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
            if (iterator != null) continue;
            iterator = this.it;
        }
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    public void clear() {
        this.it = null;
    }

    @Override
    public boolean isEmpty() {
        return this.it == null;
    }

    @Override
    @Nullable
    public R poll() {
        Iterator<R> iterator = this.it;
        if (iterator != null) {
            R v2 = ObjectHelper.requireNonNull(iterator.next(), "The iterator returned a null value");
            if (!iterator.hasNext()) {
                this.it = null;
            }
            return v2;
        }
        return null;
    }
}

