/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.MaybeFlatMapSingle$FlatMapSingleObserver;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeFlatMapSingle$FlatMapMaybeObserver<T, R>
extends AtomicReference<Disposable>
implements MaybeObserver<T>,
Disposable {
    private static final long serialVersionUID = 4827726964688405508L;
    final SingleObserver<? super R> actual;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;

    MaybeFlatMapSingle$FlatMapMaybeObserver(SingleObserver<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        SingleSource<R> ss2;
        try {
            ss2 = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null SingleSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.onError(ex2);
            return;
        }
        if (!this.isDisposed()) {
            ss2.subscribe(new MaybeFlatMapSingle$FlatMapSingleObserver<R>(this, this.actual));
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.actual.onError(new NoSuchElementException());
    }
}

