/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.MaybeFlatMapSingleElement$FlatMapSingleObserver;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeFlatMapSingleElement$FlatMapMaybeObserver<T, R>
extends AtomicReference<Disposable>
implements MaybeObserver<T>,
Disposable {
    private static final long serialVersionUID = 4827726964688405508L;
    final MaybeObserver<? super R> actual;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;

    MaybeFlatMapSingleElement$FlatMapMaybeObserver(MaybeObserver<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        SingleSource<R> ss2;
        try {
            ss2 = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null SingleSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.onError(ex2);
            return;
        }
        ss2.subscribe(new MaybeFlatMapSingleElement$FlatMapSingleObserver<R>(this, this.actual));
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }
}

