/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class MaybeFromAction<T>
extends Maybe<T>
implements Callable<T> {
    final Action action;

    public MaybeFromAction(Action action) {
        this.action = action;
    }

    @Override
    public void subscribeActual(MaybeObserver<? super T> observer) {
        Disposable d2 = Disposables.empty();
        observer.onSubscribe(d2);
        if (!d2.isDisposed()) {
            try {
                this.action.run();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                if (!d2.isDisposed()) {
                    observer.onError(ex2);
                } else {
                    RxJavaPlugins.onError(ex2);
                }
                return;
            }
            if (!d2.isDisposed()) {
                observer.onComplete();
            }
        }
    }

    @Override
    public T call() {
        this.action.run();
        return null;
    }
}

