/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class MaybeFromCallable<T>
extends Maybe<T>
implements Callable<T> {
    final Callable<? extends T> callable;

    public MaybeFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribeActual(MaybeObserver<? super T> observer) {
        Disposable d2 = Disposables.empty();
        observer.onSubscribe(d2);
        if (!d2.isDisposed()) {
            T v2;
            try {
                v2 = this.callable.call();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                if (!d2.isDisposed()) {
                    observer.onError(ex2);
                } else {
                    RxJavaPlugins.onError(ex2);
                }
                return;
            }
            if (!d2.isDisposed()) {
                if (v2 == null) {
                    observer.onComplete();
                } else {
                    observer.onSuccess(v2);
                }
            }
        }
    }

    @Override
    public T call() {
        return this.callable.call();
    }
}

