/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;

final class MaybeMap$MapMaybeObserver<T, R>
implements MaybeObserver<T>,
Disposable {
    final MaybeObserver<? super R> actual;
    final Function<? super T, ? extends R> mapper;
    Disposable d;

    MaybeMap$MapMaybeObserver(MaybeObserver<? super R> actual, Function<? super T, ? extends R> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void dispose() {
        Disposable d2 = this.d;
        this.d = DisposableHelper.DISPOSED;
        d2.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        R v2;
        try {
            v2 = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null item");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(ex2);
            return;
        }
        this.actual.onSuccess(v2);
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }
}

