/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeObserveOn$ObserveOnMaybeObserver<T>
extends AtomicReference<Disposable>
implements MaybeObserver<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = 8571289934935992137L;
    final MaybeObserver<? super T> actual;
    final Scheduler scheduler;
    T value;
    Throwable error;

    MaybeObserveOn$ObserveOnMaybeObserver(MaybeObserver<? super T> actual, Scheduler scheduler) {
        this.actual = actual;
        this.scheduler = scheduler;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
    }

    @Override
    public void onError(Throwable e2) {
        this.error = e2;
        DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
    }

    @Override
    public void onComplete() {
        DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
    }

    @Override
    public void run() {
        Throwable ex2 = this.error;
        if (ex2 != null) {
            this.error = null;
            this.actual.onError(ex2);
        } else {
            T v2 = this.value;
            if (v2 != null) {
                this.value = null;
                this.actual.onSuccess(v2);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

