/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.MaybeOnErrorNext$OnErrorNextMaybeObserver$NextMaybeObserver;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeOnErrorNext$OnErrorNextMaybeObserver<T>
extends AtomicReference<Disposable>
implements MaybeObserver<T>,
Disposable {
    private static final long serialVersionUID = 2026620218879969836L;
    final MaybeObserver<? super T> actual;
    final Function<? super Throwable, ? extends MaybeSource<? extends T>> resumeFunction;
    final boolean allowFatal;

    MaybeOnErrorNext$OnErrorNextMaybeObserver(MaybeObserver<? super T> actual, Function<? super Throwable, ? extends MaybeSource<? extends T>> resumeFunction, boolean allowFatal) {
        this.actual = actual;
        this.resumeFunction = resumeFunction;
        this.allowFatal = allowFatal;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.actual.onSuccess(value);
    }

    @Override
    public void onError(Throwable e2) {
        MaybeSource<? super T> m2;
        if (!this.allowFatal && !(e2 instanceof Exception)) {
            this.actual.onError(e2);
            return;
        }
        try {
            m2 = ObjectHelper.requireNonNull(this.resumeFunction.apply(e2), "The resumeFunction returned a null MaybeSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(new CompositeException(e2, ex2));
            return;
        }
        DisposableHelper.replace(this, null);
        m2.subscribe(new MaybeOnErrorNext$OnErrorNextMaybeObserver$NextMaybeObserver<T>(this.actual, this));
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }
}

